/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rsf.managereqs;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.managereqs.RsfRequestInfo;
import com.ibm.hwmca.fw.rsf.managereqs.RsfRequestsConstants;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.impl.RawRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RsfRequestsBean
extends PanelBean
implements RsfRequestsConstants {
    private static final String TRACE_MASKT = "XRSFRQBT";
    private static final String TRACE_MASKF = "XRSFRQBF";
    private static final String TRACE_MASKD = "XRSFRQBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RSF-ReqsBean");
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private List activeReqInfo;
    private List waitingReqInfo;
    private transient Object requestInfoLock;
    private transient ItemDescriptor[][] m_idActiveRequestsTable;
    private transient ColumnDescriptor[] m_cdActiveRequestsTableStructure;
    private transient int[] m_iActiveRequestsTableSelection;
    private transient ItemDescriptor[][] m_idWaitingRequestsTable;
    private transient ColumnDescriptor[] m_cdWaitingRequestsTableStructure;
    private transient int[] m_iWaitingRequestsTableSelection;

    public RsfRequestsBean() {
        Trace.trace(TRACE_MASKT, "<> RsfRequestsBean()");
    }

    public void setActiveRequestsTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iActiveRequestsTableSelection = selected;
    }

    public int[] getActiveRequestsTableSelection() {
        return this.m_iActiveRequestsTableSelection;
    }

    public void setActiveRequestsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idActiveRequestsTable[index] = items;
    }

    public ItemDescriptor[] getActiveRequestsTableRowAt(int index) {
        return this.m_idActiveRequestsTable[index];
    }

    public int getActiveRequestsTableRowCount() {
        return this.m_idActiveRequestsTable.length;
    }

    public int getActiveRequestsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getActiveRequestsTableRowStructure() {
        return this.m_cdActiveRequestsTableStructure;
    }

    public void setWaitingRequestsTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iWaitingRequestsTableSelection = selected;
    }

    public int[] getWaitingRequestsTableSelection() {
        return this.m_iWaitingRequestsTableSelection;
    }

    public void setWaitingRequestsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idWaitingRequestsTable[index] = items;
    }

    public ItemDescriptor[] getWaitingRequestsTableRowAt(int index) {
        return this.m_idWaitingRequestsTable[index];
    }

    public int getWaitingRequestsTableRowCount() {
        return this.m_idWaitingRequestsTable.length;
    }

    public int getWaitingRequestsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getWaitingRequestsTableRowStructure() {
        return this.m_cdWaitingRequestsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_idActiveRequestsTable = new ItemDescriptor[0][0];
        this.m_cdActiveRequestsTableStructure = new ColumnDescriptor[0];
        this.m_iActiveRequestsTableSelection = new int[0];
        this.m_idWaitingRequestsTable = new ItemDescriptor[0][0];
        this.m_cdWaitingRequestsTableStructure = new ColumnDescriptor[0];
        this.m_iWaitingRequestsTableSelection = new int[0];
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.requestInfoLock = new Object();
        this.activeReqInfo = new ArrayList();
        this.waitingReqInfo = new ArrayList();
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setSource(this.getUniqueTaskletRequestId());
        request.setData("Source", "RsfRequestsPanel");
        request.setData("Command", "UpdateRequestInfo");
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        block23: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                if (element.endsWith("ViewCallHomeServersItem")) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource(this.getUniqueTaskletRequestId());
                    request.setData("Source", "RsfRequestsPanel");
                    request.setData("Command", "OpenCallHomeServersPanel");
                    this.postTaskletRequest(request);
                    break block23;
                }
                if (element.endsWith("CancelSelectedRequestsItem")) {
                    ArrayList selectedReqs = new ArrayList();
                    Object object = this.requestInfoLock;
                    synchronized (object) {
                        int i;
                        for (i = 0; i < this.m_iActiveRequestsTableSelection.length; ++i) {
                            selectedReqs.add(this.activeReqInfo.get(this.m_iActiveRequestsTableSelection[i]));
                        }
                        for (i = 0; i < this.m_iWaitingRequestsTableSelection.length; ++i) {
                            selectedReqs.add(this.waitingReqInfo.get(this.m_iWaitingRequestsTableSelection[i]));
                        }
                    }
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource(this.getUniqueTaskletRequestId());
                    request.setData("Source", "RsfRequestsPanel");
                    request.setData("Command", "CancelRequests");
                    request.setData("RequestInfo", selectedReqs);
                    this.postTaskletRequest(request);
                    break block23;
                }
                if (element.endsWith("CancelActiveRequestsItem")) {
                    ArrayList activeReqs;
                    Object request = this.requestInfoLock;
                    synchronized (request) {
                        activeReqs = new ArrayList(this.activeReqInfo);
                    }
                    request = new PanelTaskletRequest();
                    ((TaskletRequest)request).setSource(this.getUniqueTaskletRequestId());
                    ((RawRequest)request).setData("Source", "RsfRequestsPanel");
                    ((RawRequest)request).setData("Command", "CancelRequests");
                    ((RawRequest)request).setData("RequestInfo", activeReqs);
                    this.postTaskletRequest((PanelTaskletRequest)request);
                    break block23;
                }
                if (element.endsWith("CancelWaitingRequestsItem")) {
                    ArrayList waitingReqs;
                    Object request = this.requestInfoLock;
                    synchronized (request) {
                        waitingReqs = new ArrayList(this.waitingReqInfo);
                    }
                    request = new PanelTaskletRequest();
                    ((TaskletRequest)request).setSource(this.getUniqueTaskletRequestId());
                    ((RawRequest)request).setData("Source", "RsfRequestsPanel");
                    ((RawRequest)request).setData("Command", "CancelRequests");
                    ((RawRequest)request).setData("RequestInfo", waitingReqs);
                    this.postTaskletRequest((PanelTaskletRequest)request);
                    break block23;
                }
                if (element.endsWith("ExitItem") || element.equalsIgnoreCase("Cancel")) {
                    this.dispose();
                } else if (element.endsWith("RsfRequestsPanel")) {
                    if (event.getActionCommand().equalsIgnoreCase("Cancel")) {
                        this.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown action command");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown element");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1141, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object newData) {
        block8: {
            Trace.trace(TRACE_MASKT, "-> update");
            try {
                HashMap data = (HashMap)newData;
                String command = (String)data.get("Command");
                if (command == null) {
                    command = "";
                }
                Trace.trace(TRACE_MASKF, "command=" + command);
                if (command.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified command");
                    break block8;
                }
                if (command.equals("UpdateRequestInfo")) {
                    List[] requests = (List[])data.get("RequestInfo");
                    Object object = this.requestInfoLock;
                    synchronized (object) {
                        this.activeReqInfo = requests[0];
                        this.waitingReqInfo = requests[1];
                        this.updateDataBeanInfo(false);
                    }
                    this.updateUTMElements();
                    break block8;
                }
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1141, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- update");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        int numOfActive = this.activeReqInfo.size();
        Trace.trace(TRACE_MASKF, "activeReqs=" + numOfActive);
        this.m_idActiveRequestsTable = new ItemDescriptor[numOfActive][5];
        if (numOfActive > 0) {
            for (int i = 0; i < numOfActive; ++i) {
                RsfRequestInfo reqInfo = (RsfRequestInfo)this.activeReqInfo.get(i);
                this.m_idActiveRequestsTable[i][0] = new ItemDescriptor(null, reqInfo.getState());
                this.m_idActiveRequestsTable[i][1] = new ItemDescriptor(null, reqInfo.getCallHomeServer());
                Calendar created = this.getCalendar(reqInfo.getDate());
                this.m_idActiveRequestsTable[i][2] = new DateItemDescriptor(null, created);
                this.m_idActiveRequestsTable[i][3] = new TimeItemDescriptor(null, created);
                String desc = reqInfo.getDescription().toString();
                this.m_idActiveRequestsTable[i][4] = new ItemDescriptor(null, desc);
            }
            this.m_iActiveRequestsTableSelection = new int[0];
        } else {
            this.m_iActiveRequestsTableSelection = new int[0];
        }
        int numOfWaiting = this.waitingReqInfo.size();
        Trace.trace(TRACE_MASKF, "waitingReqs=" + numOfWaiting);
        this.m_idWaitingRequestsTable = new ItemDescriptor[numOfWaiting][3];
        if (numOfWaiting > 0) {
            for (int i = 0; i < numOfWaiting; ++i) {
                RsfRequestInfo reqInfo = (RsfRequestInfo)this.waitingReqInfo.get(i);
                Calendar created = this.getCalendar(reqInfo.getDate());
                this.m_idWaitingRequestsTable[i][0] = new DateItemDescriptor(null, created);
                this.m_idWaitingRequestsTable[i][1] = new TimeItemDescriptor(null, created);
                String desc = reqInfo.getDescription().toString();
                this.m_idWaitingRequestsTable[i][2] = new ItemDescriptor(null, desc);
            }
            this.m_iWaitingRequestsTableSelection = new int[0];
        } else {
            this.m_iWaitingRequestsTableSelection = new int[0];
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        RsfRequestsBean rsfRequestsBean = this;
        synchronized (rsfRequestsBean) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.taskletRequestId);
            sb.append("-");
            sb.append(++this.taskletRequestNum);
            return sb.toString();
        }
    }

    private Calendar getCalendar(Date date) {
        Calendar calendar = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            calendar = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        return calendar;
    }
}

